/*
 * Decompiled with CFR 0.152.
 */
package com.keyes.youtube;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.MediaPlayer;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.MediaController;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.VideoView;
import com.keyes.youtube.PlaylistId;
import com.keyes.youtube.VideoId;
import com.keyes.youtube.YouTubeId;
import com.keyes.youtube.YouTubeUtility;

public class OpenYouTubePlayerActivity
extends Activity {
    public static final String SCHEME_YOUTUBE_VIDEO = "ytv";
    public static final String SCHEME_YOUTUBE_PLAYLIST = "ytpl";
    static final String YOUTUBE_VIDEO_INFORMATION_URL = "http://www.youtube.com/get_video_info?&video_id=";
    static final String YOUTUBE_PLAYLIST_ATOM_FEED_URL = "http://gdata.youtube.com/feeds/api/playlists/";
    protected ProgressBar mProgressBar;
    protected TextView mProgressMessage;
    protected VideoView mVideoView;
    public static final String MSG_INIT = "com.keyes.video.msg.init";
    protected String mMsgInit = "Initializing";
    public static final String MSG_DETECT = "com.keyes.video.msg.detect";
    protected String mMsgDetect = "Detecting Bandwidth";
    public static final String MSG_PLAYLIST = "com.keyes.video.msg.playlist";
    protected String mMsgPlaylist = "Determining Latest Video in YouTube Playlist";
    public static final String MSG_TOKEN = "com.keyes.video.msg.token";
    protected String mMsgToken = "Retrieving YouTube Video Token";
    public static final String MSG_LO_BAND = "com.keyes.video.msg.loband";
    protected String mMsgLowBand = "Buffering Low-bandwidth Video";
    public static final String MSG_HI_BAND = "com.keyes.video.msg.hiband";
    protected String mMsgHiBand = "Buffering High-bandwidth Video";
    public static final String MSG_ERROR_TITLE = "com.keyes.video.msg.error.title";
    protected String mMsgErrorTitle = "Communications Error";
    public static final String MSG_ERROR_MSG = "com.keyes.video.msg.error.msg";
    protected String mMsgError = "An error occurred during the retrieval of the video.  This could be due to network issues or YouTube protocols.  Please try again later.";
    protected QueryYouTubeTask mQueryYouTubeTask;
    protected String mVideoId = null;

    protected void onCreate(Bundle pSavedInstanceState) {
        super.onCreate(pSavedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setupView();
        this.extractMessages();
        this.getWindow().setFlags(128, 128);
        this.mProgressBar.bringToFront();
        this.mProgressBar.setVisibility(0);
        this.mProgressMessage.setText((CharSequence)this.mMsgInit);
        Uri lVideoIdUri = this.getIntent().getData();
        if (lVideoIdUri == null) {
            Log.i((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"No video ID was specified in the intent.  Closing video activity.");
            this.finish();
        }
        String lVideoSchemeStr = lVideoIdUri.getScheme();
        String lVideoIdStr = lVideoIdUri.getEncodedSchemeSpecificPart();
        if (lVideoIdStr == null) {
            Log.i((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"No video ID was specified in the intent.  Closing video activity.");
            this.finish();
        }
        if (lVideoIdStr.startsWith("//")) {
            if (lVideoIdStr.length() > 2) {
                lVideoIdStr = lVideoIdStr.substring(2);
            } else {
                Log.i((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"No video ID was specified in the intent.  Closing video activity.");
                this.finish();
            }
        }
        YouTubeId lYouTubeId = null;
        if (lVideoSchemeStr != null && lVideoSchemeStr.equalsIgnoreCase(SCHEME_YOUTUBE_PLAYLIST)) {
            lYouTubeId = new PlaylistId(lVideoIdStr);
        } else if (lVideoSchemeStr != null && lVideoSchemeStr.equalsIgnoreCase(SCHEME_YOUTUBE_VIDEO)) {
            lYouTubeId = new VideoId(lVideoIdStr);
        }
        if (lYouTubeId == null) {
            Log.i((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Unable to extract video ID from the intent.  Closing video activity.");
            this.finish();
        }
        this.mQueryYouTubeTask = (QueryYouTubeTask)new QueryYouTubeTask().execute(new YouTubeId[]{lYouTubeId});
    }

    private void extractMessages() {
        String lMsgErrMsg;
        String lMsgErrTitle;
        String lMsgHiBand;
        String lMsgLoBand;
        String lMsgToken;
        String lMsgPlaylist;
        String lMsgDetect;
        Intent lInvokingIntent = this.getIntent();
        String lMsgInit = lInvokingIntent.getStringExtra(MSG_INIT);
        if (lMsgInit != null) {
            this.mMsgInit = lMsgInit;
        }
        if ((lMsgDetect = lInvokingIntent.getStringExtra(MSG_DETECT)) != null) {
            this.mMsgDetect = lMsgDetect;
        }
        if ((lMsgPlaylist = lInvokingIntent.getStringExtra(MSG_PLAYLIST)) != null) {
            this.mMsgPlaylist = lMsgPlaylist;
        }
        if ((lMsgToken = lInvokingIntent.getStringExtra(MSG_TOKEN)) != null) {
            this.mMsgToken = lMsgToken;
        }
        if ((lMsgLoBand = lInvokingIntent.getStringExtra(MSG_LO_BAND)) != null) {
            this.mMsgLowBand = lMsgLoBand;
        }
        if ((lMsgHiBand = lInvokingIntent.getStringExtra(MSG_HI_BAND)) != null) {
            this.mMsgHiBand = lMsgHiBand;
        }
        if ((lMsgErrTitle = lInvokingIntent.getStringExtra(MSG_ERROR_TITLE)) != null) {
            this.mMsgErrorTitle = lMsgErrTitle;
        }
        if ((lMsgErrMsg = lInvokingIntent.getStringExtra(MSG_ERROR_MSG)) != null) {
            this.mMsgError = lMsgErrMsg;
        }
    }

    private void setupView() {
        LinearLayout lLinLayout = new LinearLayout((Context)this);
        lLinLayout.setId(1);
        lLinLayout.setOrientation(1);
        lLinLayout.setGravity(17);
        lLinLayout.setBackgroundColor(-16777216);
        LinearLayout.LayoutParams lLinLayoutParms = new LinearLayout.LayoutParams(-1, -1);
        lLinLayout.setLayoutParams((ViewGroup.LayoutParams)lLinLayoutParms);
        this.setContentView((View)lLinLayout);
        RelativeLayout lRelLayout = new RelativeLayout((Context)this);
        lRelLayout.setId(2);
        lRelLayout.setGravity(17);
        lRelLayout.setBackgroundColor(-16777216);
        RelativeLayout.LayoutParams lRelLayoutParms = new RelativeLayout.LayoutParams(-1, -1);
        lRelLayout.setLayoutParams((ViewGroup.LayoutParams)lRelLayoutParms);
        lLinLayout.addView((View)lRelLayout);
        this.mVideoView = new VideoView((Context)this);
        this.mVideoView.setId(3);
        RelativeLayout.LayoutParams lVidViewLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
        lVidViewLayoutParams.addRule(13);
        this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)lVidViewLayoutParams);
        lRelLayout.addView((View)this.mVideoView);
        this.mProgressBar = new ProgressBar((Context)this);
        this.mProgressBar.setIndeterminate(true);
        this.mProgressBar.setVisibility(0);
        this.mProgressBar.setEnabled(true);
        this.mProgressBar.setId(4);
        RelativeLayout.LayoutParams lProgressBarLayoutParms = new RelativeLayout.LayoutParams(-2, -2);
        lProgressBarLayoutParms.addRule(13);
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)lProgressBarLayoutParms);
        lRelLayout.addView((View)this.mProgressBar);
        this.mProgressMessage = new TextView((Context)this);
        this.mProgressMessage.setId(5);
        RelativeLayout.LayoutParams lProgressMsgLayoutParms = new RelativeLayout.LayoutParams(-2, -2);
        lProgressMsgLayoutParms.addRule(14);
        lProgressMsgLayoutParms.addRule(3, 4);
        this.mProgressMessage.setLayoutParams((ViewGroup.LayoutParams)lProgressMsgLayoutParms);
        this.mProgressMessage.setTextColor(-3355444);
        this.mProgressMessage.setTextSize(2, 12.0f);
        this.mProgressMessage.setText((CharSequence)"...");
        lRelLayout.addView((View)this.mProgressMessage);
    }

    protected void onDestroy() {
        super.onDestroy();
        YouTubeUtility.markVideoAsViewed((Context)this, this.mVideoId);
        if (this.mQueryYouTubeTask != null) {
            this.mQueryYouTubeTask.cancel(true);
        }
        if (this.mVideoView != null) {
            this.mVideoView.stopPlayback();
        }
        this.getWindow().clearFlags(128);
        this.mQueryYouTubeTask = null;
        this.mVideoView = null;
    }

    public void updateProgress(String pProgressMsg) {
        try {
            this.mProgressMessage.setText((CharSequence)pProgressMsg);
        }
        catch (Exception e) {
            Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Error updating video status!", (Throwable)e);
        }
    }

    protected void onStart() {
        super.onStart();
    }

    protected void onStop() {
        super.onStop();
    }

    private class ProgressUpdateInfo {
        public String mMsg;

        public ProgressUpdateInfo(String pMsg) {
            this.mMsg = pMsg;
        }
    }

    private class QueryYouTubeTask
    extends AsyncTask<YouTubeId, ProgressUpdateInfo, Uri> {
        private boolean mShowedError = false;

        private QueryYouTubeTask() {
        }

        protected Uri doInBackground(YouTubeId ... pParams) {
            String lYouTubeFmtQuality;
            String lUriStr;
            block13: {
                String lYouTubeVideoId;
                block12: {
                    lUriStr = null;
                    lYouTubeFmtQuality = "17";
                    lYouTubeVideoId = null;
                    if (this.isCancelled()) {
                        return null;
                    }
                    this.publishProgress(new ProgressUpdateInfo[]{new ProgressUpdateInfo(OpenYouTubePlayerActivity.this.mMsgDetect)});
                    WifiManager lWifiManager = (WifiManager)OpenYouTubePlayerActivity.this.getSystemService("wifi");
                    TelephonyManager lTelephonyManager = (TelephonyManager)OpenYouTubePlayerActivity.this.getSystemService("phone");
                    if (lWifiManager.isWifiEnabled() && lWifiManager.getConnectionInfo() != null && lWifiManager.getConnectionInfo().getIpAddress() != 0 || (lTelephonyManager.getNetworkType() == 3 || lTelephonyManager.getNetworkType() == 9 || lTelephonyManager.getNetworkType() == 10 || lTelephonyManager.getNetworkType() == 8 || lTelephonyManager.getNetworkType() == 5 || lTelephonyManager.getNetworkType() == 6) && lTelephonyManager.getDataState() == 2) {
                        lYouTubeFmtQuality = "18";
                    }
                    if (pParams[0] instanceof PlaylistId) {
                        this.publishProgress(new ProgressUpdateInfo[]{new ProgressUpdateInfo(OpenYouTubePlayerActivity.this.mMsgPlaylist)});
                        lYouTubeVideoId = YouTubeUtility.queryLatestPlaylistVideo((PlaylistId)pParams[0]);
                    } else if (pParams[0] instanceof VideoId) {
                        lYouTubeVideoId = pParams[0].getId();
                    }
                    OpenYouTubePlayerActivity.this.mVideoId = lYouTubeVideoId;
                    this.publishProgress(new ProgressUpdateInfo[]{new ProgressUpdateInfo(OpenYouTubePlayerActivity.this.mMsgToken)});
                    if (!this.isCancelled()) break block12;
                    return null;
                }
                lUriStr = YouTubeUtility.calculateYouTubeUrl(lYouTubeFmtQuality, true, lYouTubeVideoId);
                if (!this.isCancelled()) break block13;
                return null;
            }
            try {
                if (lYouTubeFmtQuality.equals("17")) {
                    this.publishProgress(new ProgressUpdateInfo[]{new ProgressUpdateInfo(OpenYouTubePlayerActivity.this.mMsgLowBand)});
                } else {
                    this.publishProgress(new ProgressUpdateInfo[]{new ProgressUpdateInfo(OpenYouTubePlayerActivity.this.mMsgHiBand)});
                }
            }
            catch (Exception e) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Error occurred while retrieving information from YouTube.", (Throwable)e);
            }
            if (lUriStr != null) {
                return Uri.parse(lUriStr);
            }
            return null;
        }

        protected void onPostExecute(Uri pResult) {
            block7: {
                super.onPostExecute((Object)pResult);
                try {
                    if (this.isCancelled()) {
                        return;
                    }
                    if (pResult == null) {
                        throw new RuntimeException("Invalid NULL Url.");
                    }
                    OpenYouTubePlayerActivity.this.mVideoView.setVideoURI(pResult);
                    if (this.isCancelled()) {
                        return;
                    }
                    OpenYouTubePlayerActivity.this.mVideoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                        public void onCompletion(MediaPlayer pMp) {
                            if (QueryYouTubeTask.this.isCancelled()) {
                                return;
                            }
                            OpenYouTubePlayerActivity.this.finish();
                        }
                    });
                    if (this.isCancelled()) {
                        return;
                    }
                    MediaController lMediaController = new MediaController((Context)OpenYouTubePlayerActivity.this);
                    OpenYouTubePlayerActivity.this.mVideoView.setMediaController(lMediaController);
                    lMediaController.show(0);
                    OpenYouTubePlayerActivity.this.mVideoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                        public void onPrepared(MediaPlayer pMp) {
                            if (QueryYouTubeTask.this.isCancelled()) {
                                return;
                            }
                            ((QueryYouTubeTask)QueryYouTubeTask.this).OpenYouTubePlayerActivity.this.mProgressBar.setVisibility(8);
                            ((QueryYouTubeTask)QueryYouTubeTask.this).OpenYouTubePlayerActivity.this.mProgressMessage.setVisibility(8);
                        }
                    });
                    if (this.isCancelled()) {
                        return;
                    }
                    OpenYouTubePlayerActivity.this.mVideoView.requestFocus();
                    OpenYouTubePlayerActivity.this.mVideoView.start();
                }
                catch (Exception e) {
                    Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Error playing video!", (Throwable)e);
                    if (this.mShowedError) break block7;
                    this.showErrorAlert();
                }
            }
        }

        private void showErrorAlert() {
            try {
                AlertDialog.Builder lBuilder = new AlertDialog.Builder((Context)OpenYouTubePlayerActivity.this);
                lBuilder.setTitle((CharSequence)OpenYouTubePlayerActivity.this.mMsgErrorTitle);
                lBuilder.setCancelable(false);
                lBuilder.setMessage((CharSequence)OpenYouTubePlayerActivity.this.mMsgError);
                lBuilder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface pDialog, int pWhich) {
                        OpenYouTubePlayerActivity.this.finish();
                    }
                });
                AlertDialog lDialog = lBuilder.create();
                lDialog.show();
            }
            catch (Exception e) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Problem showing error dialog.", (Throwable)e);
            }
        }

        protected void onProgressUpdate(ProgressUpdateInfo ... pValues) {
            super.onProgressUpdate((Object[])pValues);
            OpenYouTubePlayerActivity.this.updateProgress(pValues[0].mMsg);
        }
    }
}

