/*
 * Decompiled with CFR 0.152.
 */
package com.keyes.youtube;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.util.Log;
import com.keyes.youtube.Format;
import com.keyes.youtube.PlaylistId;
import com.keyes.youtube.VideoStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class YouTubeUtility {
    public static String queryLatestPlaylistVideo(PlaylistId pPlaylistId) throws IOException, ClientProtocolException, FactoryConfigurationError {
        String lVideoId = null;
        DefaultHttpClient lClient = new DefaultHttpClient();
        HttpGet lGetMethod = new HttpGet("http://gdata.youtube.com/feeds/api/playlists/" + pPlaylistId.getId() + "?v=2&max-results=50&alt=json");
        HttpResponse lResp = null;
        lResp = lClient.execute((HttpUriRequest)lGetMethod);
        ByteArrayOutputStream lBOS = new ByteArrayOutputStream();
        String lInfoStr = null;
        JSONObject lYouTubeResponse = null;
        try {
            lResp.getEntity().writeTo((OutputStream)lBOS);
            lInfoStr = lBOS.toString("UTF-8");
            lYouTubeResponse = new JSONObject(lInfoStr);
            JSONArray lEntryArr = lYouTubeResponse.getJSONObject("feed").getJSONArray("entry");
            JSONArray lLinkArr = lEntryArr.getJSONObject(lEntryArr.length() - 1).getJSONArray("link");
            int i = 0;
            while (i < lLinkArr.length()) {
                JSONObject lLinkObj = lLinkArr.getJSONObject(i);
                String lRelVal = lLinkObj.optString("rel", null);
                if (lRelVal != null && lRelVal.equals("alternate")) {
                    String lUriStr = lLinkObj.optString("href", null);
                    Uri lVideoUri = Uri.parse((String)lUriStr);
                    lVideoId = lVideoUri.getQueryParameter("v");
                    break;
                }
                ++i;
            }
        }
        catch (IllegalStateException e) {
            Log.i((String)YouTubeUtility.class.getSimpleName(), (String)"Error retrieving content from YouTube", (Throwable)e);
        }
        catch (IOException e) {
            Log.i((String)YouTubeUtility.class.getSimpleName(), (String)"Error retrieving content from YouTube", (Throwable)e);
        }
        catch (JSONException e) {
            Log.i((String)YouTubeUtility.class.getSimpleName(), (String)"Error retrieving content from YouTube", (Throwable)e);
        }
        return lVideoId;
    }

    public static String calculateYouTubeUrl(String pYouTubeFmtQuality, boolean pFallback, String pYouTubeVideoId) throws IOException, ClientProtocolException, UnsupportedEncodingException {
        String lStreamList;
        String lUriStr = null;
        DefaultHttpClient lClient = new DefaultHttpClient();
        HttpGet lGetMethod = new HttpGet("http://www.youtube.com/get_video_info?&video_id=" + pYouTubeVideoId);
        HttpResponse lResp = null;
        lResp = lClient.execute((HttpUriRequest)lGetMethod);
        ByteArrayOutputStream lBOS = new ByteArrayOutputStream();
        String lInfoStr = null;
        lResp.getEntity().writeTo((OutputStream)lBOS);
        lInfoStr = new String(lBOS.toString("UTF-8"));
        String[] lArgs = lInfoStr.split("&");
        HashMap<String, String> lArgMap = new HashMap<String, String>();
        int i = 0;
        while (i < lArgs.length) {
            String[] lArgValStrArr = lArgs[i].split("=");
            if (lArgValStrArr != null && lArgValStrArr.length >= 2) {
                lArgMap.put(lArgValStrArr[0], URLDecoder.decode(lArgValStrArr[1]));
            }
            ++i;
        }
        String lFmtList = URLDecoder.decode((String)lArgMap.get("fmt_list"));
        ArrayList<Format> lFormats = new ArrayList<Format>();
        if (lFmtList != null) {
            String[] lFormatStrs;
            String[] stringArray = lFormatStrs = lFmtList.split(",");
            int n = lFormatStrs.length;
            int n2 = 0;
            while (n2 < n) {
                String lFormatStr = stringArray[n2];
                Format lFormat = new Format(lFormatStr);
                lFormats.add(lFormat);
                ++n2;
            }
        }
        if ((lStreamList = (String)lArgMap.get("url_encoded_fmt_stream_map")) != null) {
            String[] lStreamStrs = lStreamList.split(",");
            ArrayList<VideoStream> lStreams = new ArrayList<VideoStream>();
            String[] stringArray = lStreamStrs;
            int lFormat = lStreamStrs.length;
            int n = 0;
            while (n < lFormat) {
                String lStreamStr = stringArray[n];
                VideoStream lStream = new VideoStream(lStreamStr);
                lStreams.add(lStream);
                ++n;
            }
            int lFormatId = Integer.parseInt(pYouTubeFmtQuality);
            Format lSearchFormat = new Format(lFormatId);
            while (!lFormats.contains(lSearchFormat) && pFallback) {
                int lNewId;
                int lOldId = lSearchFormat.getId();
                if (lOldId == (lNewId = YouTubeUtility.getSupportedFallbackId(lOldId))) break;
                lSearchFormat = new Format(lNewId);
            }
            int lIndex = lFormats.indexOf(lSearchFormat);
            if (lIndex >= 0) {
                VideoStream lSearchStream = (VideoStream)lStreams.get(lIndex);
                lUriStr = lSearchStream.getUrl();
            }
        }
        return lUriStr;
    }

    public static boolean hasVideoBeenViewed(Context pCtxt, String pVideoId) {
        SharedPreferences lPrefs = PreferenceManager.getDefaultSharedPreferences((Context)pCtxt);
        String lViewedVideoIds = lPrefs.getString("com.keyes.screebl.lastViewedVideoIds", null);
        if (lViewedVideoIds == null) {
            return false;
        }
        String[] lSplitIds = lViewedVideoIds.split(";");
        if (lSplitIds == null || lSplitIds.length == 0) {
            return false;
        }
        int i = 0;
        while (i < lSplitIds.length) {
            if (lSplitIds[i] != null && lSplitIds[i].equals(pVideoId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void markVideoAsViewed(Context pCtxt, String pVideoId) {
        String[] lSplitIds;
        SharedPreferences lPrefs = PreferenceManager.getDefaultSharedPreferences((Context)pCtxt);
        if (pVideoId == null) {
            return;
        }
        String lViewedVideoIds = lPrefs.getString("com.keyes.screebl.lastViewedVideoIds", null);
        if (lViewedVideoIds == null) {
            lViewedVideoIds = "";
        }
        if ((lSplitIds = lViewedVideoIds.split(";")) == null) {
            lSplitIds = new String[]{};
        }
        HashMap<String, String> lMap = new HashMap<String, String>();
        int i = 0;
        while (i < lSplitIds.length) {
            lMap.put(lSplitIds[i], lSplitIds[i]);
            ++i;
        }
        String lNewIdList = "";
        Set lKeys = lMap.keySet();
        for (String lId : lKeys) {
            if (lId.trim().equals("")) continue;
            lNewIdList = String.valueOf(lNewIdList) + lId + ";";
        }
        lNewIdList = String.valueOf(lNewIdList) + pVideoId + ";";
        SharedPreferences.Editor lPrefEdit = lPrefs.edit();
        lPrefEdit.putString("com.keyes.screebl.lastViewedVideoIds", lNewIdList);
        lPrefEdit.commit();
    }

    public static int getSupportedFallbackId(int pOldId) {
        int[] lSupportedFormatIds = new int[]{13, 17, 18, 22, 37};
        int lFallbackId = pOldId;
        int i = lSupportedFormatIds.length - 1;
        while (i >= 0) {
            if (pOldId == lSupportedFormatIds[i] && i > 0) {
                lFallbackId = lSupportedFormatIds[i - 1];
            }
            --i;
        }
        return lFallbackId;
    }
}

