/*
 * Decompiled with CFR 0.152.
 */
package io.liteglue;

import io.liteglue.SQLDatabaseHandle;
import io.liteglue.SQLStatementHandle;
import io.liteglue.SQLiteNDKNativeDriver;
import io.liteglue.SQLiteNativeResponse;

class SQLGDatabaseHandle
implements SQLDatabaseHandle {
    String dbfilename = null;
    int openflags = 0;
    private long dbhandle = 0L;

    public SQLGDatabaseHandle(String string, int n) {
        this.dbfilename = string;
        this.openflags = n;
    }

    @Override
    public int open() {
        if (this.dbfilename == null || this.dbhandle != 0L) {
            return 21;
        }
        SQLiteNativeResponse sQLiteNativeResponse = SQLiteNDKNativeDriver.sqlc_db_open(this.dbfilename, this.openflags);
        if (sQLiteNativeResponse.getResult() != 0) {
            return -sQLiteNativeResponse.getResult();
        }
        this.dbhandle = sQLiteNativeResponse.getHandle();
        return 0;
    }

    @Override
    public int close() {
        if (this.dbhandle == 0L) {
            return 21;
        }
        return SQLiteNDKNativeDriver.sqlc_db_close(this.dbhandle);
    }

    @Override
    public boolean isOpen() {
        return this.dbhandle != 0L;
    }

    @Override
    public SQLStatementHandle newStatementHandle(String string) {
        if (this.dbhandle == 0L) {
            return null;
        }
        return new SQLGStatementHandle(string);
    }

    @Override
    public long getLastInsertRowid() {
        if (this.dbhandle == 0L) {
            return -1L;
        }
        return SQLiteNDKNativeDriver.sqlc_db_last_insert_rowid(this.dbhandle);
    }

    @Override
    public int getTotalChanges() {
        if (this.dbhandle == 0L) {
            return -1;
        }
        return SQLiteNDKNativeDriver.sqlc_db_total_changes(this.dbhandle);
    }

    @Override
    public String getLastErrorMessage() {
        if (this.dbhandle == 0L) {
            return null;
        }
        return SQLiteNDKNativeDriver.sqlc_db_errmsg_native(this.dbhandle);
    }

    private class SQLGStatementHandle
    implements SQLStatementHandle {
        String sql = null;
        private long sthandle = 0L;

        private SQLGStatementHandle(String string) {
            this.sql = string;
        }

        @Override
        public int prepare() {
            if (this.sql == null || this.sthandle != 0L) {
                return 21;
            }
            SQLiteNativeResponse sQLiteNativeResponse = SQLiteNDKNativeDriver.sqlc_db_prepare_st(SQLGDatabaseHandle.this.dbhandle, this.sql);
            if (sQLiteNativeResponse.getResult() != 0) {
                return -sQLiteNativeResponse.getResult();
            }
            this.sthandle = sQLiteNativeResponse.getHandle();
            return 0;
        }

        @Override
        public int bindDouble(int n, double d) {
            if (this.sthandle == 0L) {
                return 21;
            }
            return SQLiteNDKNativeDriver.sqlc_st_bind_double(this.sthandle, n, d);
        }

        @Override
        public int bindInteger(int n, int n2) {
            if (this.sthandle == 0L) {
                return 21;
            }
            return SQLiteNDKNativeDriver.sqlc_st_bind_int(this.sthandle, n, n2);
        }

        @Override
        public int bindLong(int n, long l) {
            if (this.sthandle == 0L) {
                return 21;
            }
            return SQLiteNDKNativeDriver.sqlc_st_bind_long(this.sthandle, n, l);
        }

        @Override
        public int bindNull(int n) {
            if (this.sthandle == 0L) {
                return 21;
            }
            return SQLiteNDKNativeDriver.sqlc_st_bind_null(this.sthandle, n);
        }

        @Override
        public int bindTextNativeString(int n, String string) {
            if (this.sthandle == 0L) {
                return 21;
            }
            return SQLiteNDKNativeDriver.sqlc_st_bind_text_native(this.sthandle, n, string);
        }

        @Override
        public int step() {
            if (this.sthandle == 0L) {
                return 21;
            }
            return SQLiteNDKNativeDriver.sqlc_st_step(this.sthandle);
        }

        @Override
        public int getColumnCount() {
            if (this.sthandle == 0L) {
                return -1;
            }
            return SQLiteNDKNativeDriver.sqlc_st_column_count(this.sthandle);
        }

        @Override
        public String getColumnName(int n) {
            if (this.sthandle == 0L) {
                return null;
            }
            return SQLiteNDKNativeDriver.sqlc_st_column_name(this.sthandle, n);
        }

        @Override
        public int getColumnType(int n) {
            if (this.sthandle == 0L) {
                return -1;
            }
            return SQLiteNDKNativeDriver.sqlc_st_column_type(this.sthandle, n);
        }

        @Override
        public double getColumnDouble(int n) {
            if (this.sthandle == 0L) {
                return -1.0;
            }
            return SQLiteNDKNativeDriver.sqlc_st_column_double(this.sthandle, n);
        }

        @Override
        public int getColumnInteger(int n) {
            if (this.sthandle == 0L) {
                return -1;
            }
            return SQLiteNDKNativeDriver.sqlc_st_column_int(this.sthandle, n);
        }

        @Override
        public long getColumnLong(int n) {
            if (this.sthandle == 0L) {
                return -1L;
            }
            return SQLiteNDKNativeDriver.sqlc_st_column_long(this.sthandle, n);
        }

        @Override
        public String getColumnTextNativeString(int n) {
            if (this.sthandle == 0L) {
                return null;
            }
            return SQLiteNDKNativeDriver.sqlc_st_column_text_native(this.sthandle, n);
        }

        @Override
        public int finish() {
            if (this.sthandle == 0L) {
                return 21;
            }
            long l = this.sthandle;
            this.sql = null;
            this.sthandle = 0L;
            return SQLiteNDKNativeDriver.sqlc_st_finish(l);
        }
    }
}

