/*
 * Decompiled with CFR 0.152.
 */
package io.liteglue;

import io.liteglue.SQLDatabaseHandle;
import io.liteglue.SQLGDatabaseHandle;
import io.liteglue.SQLStatementHandle;
import io.liteglue.SQLiteConnection;
import io.liteglue.SQLiteStatement;
import java.sql.SQLException;

class SQLiteGlueConnection
implements SQLiteConnection {
    private SQLDatabaseHandle db = null;

    public SQLiteGlueConnection(String string, int n) throws SQLException {
        if (string == null) {
            throw new SQLException("null argument", "failed", 21);
        }
        SQLGDatabaseHandle sQLGDatabaseHandle = new SQLGDatabaseHandle(string, n);
        int n2 = sQLGDatabaseHandle.open();
        if (n2 != 0) {
            throw new SQLException("sqlite3_open_v2 failure: " + sQLGDatabaseHandle.getLastErrorMessage(), "failure", n2);
        }
        this.db = sQLGDatabaseHandle;
    }

    @Override
    public void dispose() throws SQLException {
        if (this.db == null) {
            throw new SQLException("already disposed", "failed", 21);
        }
        int n = this.db.close();
        if (n != 0) {
            throw new SQLException("sqlite3_close failure: " + this.db.getLastErrorMessage(), "failure", n);
        }
        this.db = null;
    }

    @Override
    public SQLiteStatement prepareStatement(String string) throws SQLException {
        if (this.db == null) {
            throw new SQLException("already disposed", "failed", 21);
        }
        if (string == null) {
            throw new SQLException("null argument", "failed", 21);
        }
        SQLGStatement sQLGStatement = new SQLGStatement(string);
        int n = sQLGStatement.prepare();
        if (n != 0) {
            throw new SQLException("sqlite3_prepare_v2 failure: " + this.db.getLastErrorMessage(), "failure", n);
        }
        return sQLGStatement;
    }

    @Override
    public long getLastInsertRowid() throws SQLException {
        if (this.db == null) {
            throw new SQLException("already disposed", "failed", 21);
        }
        return this.db.getLastInsertRowid();
    }

    @Override
    public int getTotalChanges() throws SQLException {
        if (this.db == null) {
            throw new SQLException("already disposed", "failed", 21);
        }
        return this.db.getTotalChanges();
    }

    private class SQLGStatement
    implements SQLiteStatement {
        private SQLStatementHandle sthandle = null;
        private String sql = null;
        private boolean hasRow = false;
        private int columnCount = 0;

        SQLGStatement(String string) {
            this.sql = string;
            this.sthandle = SQLiteGlueConnection.this.db.newStatementHandle(string);
        }

        int prepare() {
            return this.sthandle.prepare();
        }

        @Override
        public void bindDouble(int n, double d) throws SQLException {
            if (this.sthandle == null) {
                throw new SQLException("already disposed", "failed", 21);
            }
            int n2 = this.sthandle.bindDouble(n, d);
            if (n2 != 0) {
                throw new SQLException("sqlite3_bind_double failure: " + SQLiteGlueConnection.this.db.getLastErrorMessage(), "failure", n2);
            }
        }

        @Override
        public void bindInteger(int n, int n2) throws SQLException {
            if (this.sthandle == null) {
                throw new SQLException("already disposed", "failed", 21);
            }
            int n3 = this.sthandle.bindInteger(n, n2);
            if (n3 != 0) {
                throw new SQLException("sqlite3_bind_int failure: " + SQLiteGlueConnection.this.db.getLastErrorMessage(), "failure", n3);
            }
        }

        @Override
        public void bindLong(int n, long l) throws SQLException {
            if (this.sthandle == null) {
                throw new SQLException("already disposed", "failed", 21);
            }
            int n2 = this.sthandle.bindLong(n, l);
            if (n2 != 0) {
                throw new SQLException("sqlite3_bind_int64 (long) failure: " + SQLiteGlueConnection.this.db.getLastErrorMessage(), "failure", n2);
            }
        }

        @Override
        public void bindNull(int n) throws SQLException {
            if (this.sthandle == null) {
                throw new SQLException("already disposed", "failed", 21);
            }
            int n2 = this.sthandle.bindNull(n);
            if (n2 != 0) {
                throw new SQLException("sqlite3_bind_null failure: " + SQLiteGlueConnection.this.db.getLastErrorMessage(), "failure", n2);
            }
        }

        @Override
        public void bindTextNativeString(int n, String string) throws SQLException {
            if (this.sthandle == null) {
                throw new SQLException("already disposed", "failed", 21);
            }
            if (string == null) {
                throw new SQLException("null argument", "failed", 21);
            }
            int n2 = this.sthandle.bindTextNativeString(n, string);
            if (n2 != 0) {
                throw new SQLException("sqlite3_bind_text failure: " + SQLiteGlueConnection.this.db.getLastErrorMessage(), "failure", n2);
            }
        }

        @Override
        public boolean step() throws SQLException {
            if (this.sthandle == null) {
                throw new SQLException("already disposed", "failed", 21);
            }
            int n = this.sthandle.step();
            if (n != 0 && n != 100 && n != 101) {
                throw new SQLException("sqlite3_step failure: " + SQLiteGlueConnection.this.db.getLastErrorMessage(), "failure", n);
            }
            this.hasRow = n == 100;
            this.columnCount = this.hasRow ? this.sthandle.getColumnCount() : 0;
            return this.hasRow;
        }

        @Override
        public int getColumnCount() throws SQLException {
            if (this.sthandle == null) {
                throw new SQLException("already disposed", "failed", 21);
            }
            if (!this.hasRow) {
                throw new SQLException("no result available", "failed", 21);
            }
            return this.columnCount;
        }

        @Override
        public String getColumnName(int n) throws SQLException {
            if (this.sthandle == null) {
                throw new SQLException("already disposed", "failed", 21);
            }
            if (!this.hasRow) {
                throw new SQLException("no result available", "failed", 21);
            }
            if (n < 0 || n >= this.columnCount) {
                throw new SQLException("no result available", "failed", 21);
            }
            return this.sthandle.getColumnName(n);
        }

        @Override
        public int getColumnType(int n) throws SQLException {
            if (this.sthandle == null) {
                throw new SQLException("already disposed", "failed", 21);
            }
            if (!this.hasRow) {
                throw new SQLException("no result available", "failed", 21);
            }
            if (n < 0 || n >= this.columnCount) {
                throw new SQLException("no result available", "failed", 21);
            }
            return this.sthandle.getColumnType(n);
        }

        @Override
        public double getColumnDouble(int n) throws SQLException {
            if (this.sthandle == null) {
                throw new SQLException("already disposed", "failed", 21);
            }
            if (!this.hasRow) {
                throw new SQLException("no result available", "failed", 21);
            }
            if (n < 0 || n >= this.columnCount) {
                throw new SQLException("no result available", "failed", 21);
            }
            return this.sthandle.getColumnDouble(n);
        }

        @Override
        public int getColumnInteger(int n) throws SQLException {
            if (this.sthandle == null) {
                throw new SQLException("already disposed", "failed", 21);
            }
            if (!this.hasRow) {
                throw new SQLException("no result available", "failed", 21);
            }
            if (n < 0 || n >= this.columnCount) {
                throw new SQLException("no result available", "failed", 21);
            }
            return this.sthandle.getColumnInteger(n);
        }

        @Override
        public long getColumnLong(int n) throws SQLException {
            if (this.sthandle == null) {
                throw new SQLException("already disposed", "failed", 21);
            }
            if (!this.hasRow) {
                throw new SQLException("no result available", "failed", 21);
            }
            if (n < 0 || n >= this.columnCount) {
                throw new SQLException("no result available", "failed", 21);
            }
            return this.sthandle.getColumnLong(n);
        }

        @Override
        public String getColumnTextNativeString(int n) throws SQLException {
            if (this.sthandle == null) {
                throw new SQLException("already disposed", "failed", 21);
            }
            if (!this.hasRow) {
                throw new SQLException("no result available", "failed", 21);
            }
            if (n < 0 || n >= this.columnCount) {
                throw new SQLException("no result available", "failed", 21);
            }
            return this.sthandle.getColumnTextNativeString(n);
        }

        @Override
        public void dispose() throws SQLException {
            if (this.sthandle == null) {
                throw new SQLException("already disposed", "failed", 21);
            }
            this.sthandle.finish();
            this.sthandle = null;
        }
    }
}

